jQuery(function ($) {
  // Global variables
  var isDenied = false;
  var isRegenerateAgeCheck = false;
  var uuid = null;
  var age_check_id = null;

  $(document).ready(function () {
    // Create manually datepicker.
    for (let i = 1; i <= 31; i++) {
      $('.date-input select#age_check_dob_day').append(
        `<option value="${i}">${i.toString().padStart(2, '0')}</option>`
      );
    }
    let bodMonth = ["Jan", "Feb", "Mar", "Apr", "May", "June", "July", "Aug", "Sept", "Oct", "Nov", "Dec"];
    for (let i = 1; i <= 12; i++) {
      $('.date-input select#age_check_dob_month').append(
        '<option value="'+ i + '">' + bodMonth[i-1] + '</option>'
      );
    }
    const currentYear = new Date().getFullYear();
    for (let i = currentYear - 18; i >= 1900; i--) {
      $('.date-input select#age_check_dob_year').append(
        `<option value="${i}">${i}</option>`
      );
    }

    // On checkout error, only for the case "is_need_age_check = true"
    $(document.body).on('checkout_error', function() {
      resetCheckoutForm();

      var $_is_need_to_check = $('.woocommerce-error').find('li[data-is_need_to_check]');
      if (!$_is_need_to_check.length) {
        return;
      }

      $_is_need_to_check.remove();

      var count = $('.woocommerce-error').find('li').length;
      if (count) {
        return;
      }

      $('.woocommerce-error').remove();
      $('.age-check-dob-overlay').show();

      age_check_id = $_is_need_to_check.data('age_check_id');
    });

    // On click cancel dob.
    $('.age-check-dob-btn-no').on('click', function() {
      $('.age-check-dob-overlay').hide();
    });

    // On click submit dob.
    $('.age-check-dob-btn-yes').on('click', function() {
      $('.woocommerce-error').remove();
      $('.age-check-dob-overlay').hide();

      if (uuid && !isRegenerateAgeCheck) {
        AgeCheckerAPI.show(uuid);
        return;
      }

      let data = {
        'dob_day'      : $('select#age_check_dob_day').val(),
        'dob_month'    : $('select#age_check_dob_month').val(),
        'dob_year'     : $('select#age_check_dob_year').val(), 
        'age_check_id' : age_check_id
      };

      $.ajax({
        type: "POST",
        url: waave_age_check_config.waave_url+'/compliance/age-check-validate',
        data:  data,
        dataType: "json",
        success: function (data) {
          if (data.success) {
            if (data.message) {
              showError(data.message);
              return;
            }

            if (data.uuid) {
              uuid = data.uuid;
              if (data.status && data.status == 'accepted') {
                updateCheckoutForm('uuid', uuid);
                updateCheckoutForm('age_check_id', age_check_id);

                $('form[name="checkout"]').submit();
              } else {
                if (isRegenerateAgeCheck) {
                  AgeCheckerAPI.show(uuid);
                } else {
                  ageCheckPopup(waave_age_check_config.age_checker, data.uuid);
                }
              }
            }
          }
        },
        error: function (xhr) {
          let message = 'Something errors. Please reload and try again.';
          if ((typeof xhr.responseJSON.message !== 'undefined')) {
            message = xhr.responseJSON.message;
          }
          showError(message);
        }
      });
    });
  });

  function ageCheckPopup(key, uuid) {
    (function (w, d) {
      var config = {
          mode: "manual",
          key: key,
          show_close: true,
          logo_url: waave_age_check_config.waave_logo,
          onhide: function () {
            uuid = null;
            $('body').css('overflow', 'unset');
          },
          onready: function () {
            AgeCheckerAPI.show(uuid);
          },
          onshow: function () {
            var agecheckerFooterStr = ''
             + '<div style="display:inline-block;margin-right: 20px;">'
             +     'Need help? Email us at <a href="mailto:support@getwaave.com" target="_blank"><span>support@getwaave.com</span></a>'
             + '</div>'
             + '<div style="display:inline-block;">'
             +     '<a href="http://static.getwaave.co/info/tos.html" target="_blank" rel="noopener">Terms of Service & Privacy Policy</a>'
             + '</div>';
            $('#agechecker #ac-footer').html(agecheckerFooterStr);
          },
          onstatuschanged: function (verification) {
            let statusDenied = ['pending', 'denied'];
            if (statusDenied.includes(verification.status)) {
              isDenied = true;
              isRegenerateAgeCheck = true;
            }
            $('#agechecker-modal').remove();
            $('input').attr("readonly", false).css({"opacity": "unset", "pointer-events": "unset"});
            $('body').css('overflow', 'unset');
            updateCheckoutForm('uuid', uuid);
            updateCheckoutForm('age_check_id', age_check_id);

            $('form[name="checkout"]').submit();
          }
      };
      w.AgeCheckerConfig = config;
      if (config.path && (w.location.pathname + w.location.search).indexOf(config.path)) return;
      var h = d.getElementsByTagName("head")[0];
      var a = d.createElement("script");
      a.src = "https://cdn.agechecker.net/static/popup/v1/popup.js";
      a.crossOrigin = "anonymous";
      a.onerror = function (a) {
          w.location.href = "https://agechecker.net/loaderror";
      }
      h.insertBefore(a, h.firstChild);
    })(window, document);
  }

  function updateCheckoutForm(name, value) {
    $('<input>').attr({
      type: 'hidden',
      id: name,
      name: name,
      value: value
    }).appendTo('form[name="checkout"]');
  }

  function resetCheckoutForm() {
    $('form[name="checkout"]').find('input[name="age_check_id"]').remove();
    $('form[name="checkout"]').find('input[name="uuid"]').remove();
  }

  function showError(message) {
    $(".woocommerce-error").remove();
    $("div.woocommerce-notices-wrapper").last().html("<ul class='woocommerce-error' role='alert' style='display:none'></ul>");
    $(".woocommerce-error").children('li').remove();
    $(".woocommerce-error").append('<li>' + message + '</li>');
    $(".woocommerce-error").show();

    var scrollElement = $( '.woocommerce-error' );
    if ( ! scrollElement.length ) {
      scrollElement = $( 'form.checkout' );
    }
    $.scroll_to_notices( scrollElement );
  }
});