<?php
/**
 * WAAVE Complete
 *
 * @class       WAAVE_Complete
 * @package WAAVE_Compliance
 */

/**
 * WAAVE_Complete
 */
class WAAVE_Complete {
	const AGE_CHECKER_URL         = 'https://api.agechecker.net/';
	const SANDBOX_AGE_CHECKER_KEY = 'Hix8qri6gxpJOP3PSHsmOilzehv8OTpI';
	const PROD_AGE_CHECKER_KEY    = 'R315tlFOdf03jMXBCgutFCkLcCBTShcH';

	/**
	 * Instance.
	 *
	 * @var this
	 */
	public static $instance;

	/**
	 * Function init.
	 */
	public static function init() {
		if ( ! self::$instance ) {
			self::$instance = new WAAVE_Complete();
		}

		return self::$instance;
	}

	/**
	 * Function construct.
	 */
	public function __construct() {
		add_action( 'woocommerce_after_checkout_validation', array( $this, 'after_checkout_validation' ) );
		add_action( 'wp_footer', array( $this, 'age_check_dob_popup' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'age_check_dob_assets' ) );

		add_filter( 'woocommerce_payment_successful_result', array( $this, 'waave_compliance_confirm' ) );
	}

	/**
	 * After checkout_validation
	 *
	 * @param array $posted posted data.
	 * @throws Exception If error.
	 */
	public function after_checkout_validation( $posted ) {
		if ( ! $this->is_compliance_checking( $posted ) ) {
			return;
		}

		$products = $this->get_cart_products();
		$billing  = $this->get_billing();
		$shipping = $this->get_shipping();

		$shipping['shipping_phone'] = $billing['billing_phone'];

		if (empty($shipping['shipping_city']) || empty($shipping['shipping_state']) || empty($shipping['shipping_country']) || empty($shipping['shipping_postcode']) || empty($shipping['shipping_address_1'])) {
			return;
		}

		$venue_id = get_option( 'waave_compliance_venue_id' );

		$body = array(
			'venue_id'              => $venue_id,
			'amount'                => WC()->cart->get_total( 'get' ),
			'email'                 => $billing['billing_email'],
			'ip_address'            => WC_Geolocation::get_ip_address(),
			'products'              => $products,
			'billing'               => $billing,
			'shipping'              => $shipping,
			'is_need_age_check'     => true,
			'compliance_standalone' => '1',
		);

		$available_gateways     = WC()->payment_gateways->get_available_payment_gateways();
		$body['payment_method'] = $available_gateways[ $posted['payment_method'] ]->title;

		$url           = WAAVE_PROD_URL . '/compliance/validate';
		$age_check_url = WAAVE_PROD_URL . '/compliance/age-check/verify';

		if ( 'yes' === get_option( 'waave_compliance_testmode' ) ) {
			$url           = WAAVE_SANDBOX_URL . '/compliance/validate';
			$age_check_url = WAAVE_SANDBOX_URL . '/compliance/age-check/verify';
		}

		// phpcs:disable WordPress.Security.NonceVerification.Missing
		if ( ! empty( $_POST['age_check_id'] ) ) {
			$body = array(
				'venue_id'        => $venue_id,
				'age_check_id'    => wp_unslash( $_POST['age_check_id'] ), // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
				'validation_code' => WC()->session->get( 'waave_validation_code' ),
			);

			$url = $age_check_url;
		}
		// phpcs:enable WordPress.Security.NonceVerification.Missing

		$options = array(
			'body' => $body,
		);

		$request  = wp_remote_post( $url, $options );
		$response = json_decode( wp_remote_retrieve_body( $request ), true );

		if ( isset( $response['message'] ) && empty( $response['success'] ) ) {
			wc_add_notice( '<strong>' . $response['message'] . '</strong>', 'error' );
		}

		if ( isset( $response['validation_code'] ) ) {
			WC()->session->set( 'waave_validation_code', $response['validation_code'] );
		}

		// phpcs:disable WordPress.Security.NonceVerification.Missing
		if ( ! empty( $_POST['uuid'] ) ) {
			return;
		}

		if ( ! empty( $response['is_need_to_check'] ) ) {
			$data = array(
				'is_need_to_check' => 1,
			);

			if ( isset( $response['age_check_id'] ) ) {
				$data['age_check_id'] = $response['age_check_id'];
			}

			wc_add_notice( ' ', 'error', $data );
		}
	}

	/**
	 * Function age_check_dob_assets.
	 */
	public function age_check_dob_assets() {
		$data    = get_plugin_data( WAAVE_COMPLIANCE_MAIN_FILE );
		$version = $data['Version'];

		wp_enqueue_style( 'waave-age-check-dob', plugins_url( '../assets/css/age-check-dob.css', __FILE__ ), array(), $version );
		wp_enqueue_script( 'waave-age-check-dob', plugins_url( '../assets/js/age-check-dob.js', __FILE__ ), array( 'jquery' ), $version, true );

		$base_url        = WAAVE_PROD_URL;
		$age_checker_key = self::PROD_AGE_CHECKER_KEY;
		if ( 'yes' === get_option( 'waave_compliance_testmode' ) ) {
			$base_url        = WAAVE_SANDBOX_URL;
			$age_checker_key = self::SANDBOX_AGE_CHECKER_KEY;
		}

		$products = $this->get_cart_products();

		wp_localize_script(
			'waave-age-check-dob',
			'waave_age_check_config',
			array(
				'waave_url'       => $base_url,
				'waave_logo'      => esc_url( WAAVE_COMPLIANCE_PLUGIN_URL . '/assets/images/logo.png' ),
				'age_checker'     => $age_checker_key,
				'venue_id'        => get_option( 'waave_compliance_venue_id' ),
				'products'        => $products,
				'enabled_methods' => get_option( 'waave_compliance_enabled_methods' ),
			)
		);
	}

	/**
	 * Function age_check_dob_popup.
	 */
	public function age_check_dob_popup() {
		if ( ! is_checkout() ) {
			return;
		}

		?>
		<div class='age-check-dob-overlay'>
			<div class='age-check-dob-popup'>
				<img class='age-verification-img' src='<?php echo esc_url( WAAVE_COMPLIANCE_PLUGIN_URL . '/assets/images/logo.png' ); ?>' alt='WAAVE Logo'>
				<h3 class='age-check-dob-title'>Enter your date of birth!</h3>
				<p class='age-check-dob-q'>
					<div class='date-input'>
						<select class='date-input-field' id='age_check_dob_month' required>
						</select>
						<select class='date-input-field' id='age_check_dob_day' required>
						</select>
						<select class='date-input-field' id='age_check_dob_year' required>
						</select>
					</div>
				</p>
				<p>Please enter your date of birth exactly as it appears on your ID mm/dd/yyyy
					<br/> otherwise we would not be able to verify your age.</p>
				<p>
					<a class='age-check-dob-btn age-check-dob-btn-yes' href='javascript:void(0)'>Submit</a>
					<a class='age-check-dob-btn age-check-dob-btn-no' href='javascript:void(0)'>Cancel</a>
				</p>
			</div>
		</div>
		<?php
	}

	/**
	 * WAAVE Compliance confirm
	 *
	 * @param array $result Result.
	 */
	public function waave_compliance_confirm( $result ) {
		$order = wc_get_order( $result['order_id'] );

		$posted = array(
			'payment_method' => $order->get_payment_method(),
		);
		if ( ! $this->is_compliance_checking( $posted ) ) {
			return $result;
		}

		$url = WAAVE_PROD_URL . '/compliance/confirm';
		if ( 'yes' === get_option( 'waave_compliance_testmode' ) ) {
			$url = WAAVE_SANDBOX_URL . '/compliance/confirm';
		}

		$options = array(
			'body' => array(
				'venue_id'           => get_option( 'waave_compliance_venue_id' ),
				'validation_code'    => WC()->session->get( 'waave_validation_code' ),
				'amount'             => (string) $order->get_total(),
				'reference_id'       => (string) $order->get_id(),
				'payment_method'     => $order->get_payment_method_title(),
				'is_payment_success' => '1',
			),
		);

		wp_remote_post( $url, $options );

		return $result;
	}

	/**
	 * Is compliance checking
	 *
	 * @param array $posted Posted data.
	 */
	private function is_compliance_checking( $posted ) {
		$payment_method  = isset( $posted['payment_method'] ) ? wc_clean( wp_unslash( $posted['payment_method'] ) ) : '';
		$enabled_methods = get_option( 'waave_compliance_enabled_methods' );

		return in_array( $payment_method, $enabled_methods, true );
	}

	/**
	 * Get cart products.
	 */
	private function get_cart_products() {
		$products = array();

		$cart_contents = WC()->cart->get_cart();
		foreach ( $cart_contents as $value ) {
			$product = $value['data'];
			if ( empty( $product ) ) {
				continue;
			}

			$product_id = $product->get_id();
			$categories = $product->get_category_ids();
			if ( 'variation' === $product->get_type() ) {
				$product_id = $product->get_parent_id();
				$parent     = wc_get_product( $product_id );
				$categories = $parent->get_category_ids();
			}

			$temp = array(
				'id'         => $product_id,
				'name'       => $product->get_name(),
				'sku'        => $product->get_sku(),
				'price'      => $product->get_price(),
				'quantity'   => $value['quantity'],
				'categories' => $categories,
			);

			$products[] = $temp;
		}

		return $products;
	}

	/**
	 * Get billing.
	 */
	private function get_billing() {
		$customer = WC()->customer;

		$billing = array();
		if ( $customer ) {
			$billing = $customer->get_billing();
		}

		return array(
			'billing_first_name' => $billing['first_name'],
			'billing_last_name'  => $billing['last_name'],
			'billing_country'    => $billing['country'],
			'billing_address_1'  => $billing['address_1'],
			'billing_address_2'  => $billing['address_2'],
			'billing_city'       => $billing['city'],
			'billing_state'      => $billing['state'] ? $billing['state'] : 'MUnicipality',
			'billing_postcode'   => $billing['postcode'],
			'billing_phone'      => $billing['phone'],
			'billing_email'      => $billing['email'],
		);
	}

	/**
	 * Get shipping.
	 */
	private function get_shipping() {
		$customer = WC()->customer;

		$shipping = array();
		if ( $customer ) {
			$shipping = $customer->get_shipping();
		}

		return array(
			'shipping_first_name' => trim($shipping['first_name']),
			'shipping_last_name'  => trim($shipping['last_name']),
			'shipping_country'    => trim($shipping['country']),
			'shipping_address_1'  => trim($shipping['address_1']),
			'shipping_address_2'  => trim($shipping['address_2']),
			'shipping_city'       => trim($shipping['city']),
			'shipping_state'      => $shipping['state'] ? trim($shipping['state']) : 'Municipality',
			'shipping_postcode'   => trim($shipping['postcode']),
		);
	}
}
