jQuery(function ($) {
  var isNeedAgeCheck = true;
  var ageCheckMode = vgs_config.age_checker_mode === '1' ? true : false;
  var isAddCreditCard = false;
  var isDenied = false;
  var isRegenerateAgeCheck = false;
  var uuid = null;
  var age_check_id = null;
  var vgsForm = null;
  var isCardNumberKeyup = false;
  var isExpirationKeyup = false;
  var isCVCKeyup = false;

  $(document.body).on("updated_checkout", function () {
    if (!$("#cc-number:has(iframe)").length) {
      vgsForm = window.VGSCollect.create(
        window.atob(vgs_config.vault_id),
        vgs_config.env,
        () => {}
      );
      const css = {
        boxSizing: "border-box",
        fontFamily: '-apple-system, BlinkMacSystemFont, "Segoe UI"',
      };

      vgsCardNumber = vgsForm.field("#cc-number", {
        type: "card-number",
        name: "card_number",
        successColor: "#4F8A10",
        errorColor: "#D8000C",
        placeholder: "Card number",
        showCardIcon: true,
        validations: ["required", "validCardNumber"],
        css: css,
      });

      vgsCvv = vgsForm.field("#cc-cvc", {
        type: "card-security-code",
        name: "cvv",
        successColor: "#4F8A10",
        errorColor: "#D8000C",
        placeholder: "CVC",
        validations: ["required", "validCardSecurityCode"],
        css: css,
      });

      vgscardExp = vgsForm.field("#cc-expiration-date", {
        type: "card-expiration-date",
        name: "card_exp",
        successColor: "#4F8A10",
        errorColor: "#D8000C",
        placeholder: "MM / YY",
        validations: ["required", "validCardExpirationDate"],
        css: css,
      });
      vgsCardNumber.on('focus', () => { 
        isAddCreditCard = false;
        isCardNumberKeyup = true;
        $('#is_error_add_card').remove();
        $('#error_add_card_form').remove();
       });
      vgsCvv.on('focus', () => { 
        isAddCreditCard = false;
        isCVCKeyup = true;
        $('#is_error_add_card').remove();
        $('#error_add_card_form').remove();
       });
      vgscardExp.on('focus', () => { 
        isAddCreditCard = false;
        isExpirationKeyup = true;
        $('#is_error_add_card').remove();
        $('#error_add_card_form').remove();
       });
    }
    isNeedAgeCheck = !!$("#is_need_age_check").val();
    age_check_id = $("#age_check_id").val();
  });
  
  $(document).ready(function() {
    $("#billing_email").change(function() {
        $(document.body).trigger('update_checkout', {update_shipping_method: false});
    });

    $('form.checkout').on('checkout_place_order_waave_checkout', function(e) {
      $("div.woocommerce-notices-wrapper").last().html("<ul class='woocommerce-error' role='alert' style='display:none'></ul>");
      if (!isNeedAgeCheck || !ageCheckMode) { 
        if (isDenied) {
          isNeedAgeCheck = true;
          isDenied = false;
        }
        return true;
      }
      $('.age-check-dob-overlay').show();
      return false;
    })

    $('form.checkout').on('checkout_place_order_waave_guest_credit_card', function(e) {
      $("div.woocommerce-notices-wrapper").last().html("<ul class='woocommerce-error' role='alert' style='display:none'></ul>");
      if (isNeedAgeCheck && ageCheckMode) {
        if (isDenied) isDenied = false;
        else {
          if (isCardNumberKeyup && isCVCKeyup && isExpirationKeyup) {
            $('.age-check-dob-overlay').show();
          } else {
            $('.woocommerce-error').children('li').remove();
            if (!isCardNumberKeyup) $(".woocommerce-error").append('<li>The card number is required</li>');
            if (!isExpirationKeyup) $(".woocommerce-error").append('<li>The card expiration is required</li>');
            if (!isCVCKeyup) $(".woocommerce-error").append('<li>The CVC is required</li>');
            $(".woocommerce-error").show();
          }
          return false;
        }
      }
      if ($('form.checkout').is('.waave-processing')) {
        $('form.checkout').removeClass('waave-processing');
        if (isAddCreditCard) {
          isAddCreditCard = false;
          return true;
        }
      }
      if (isAddCreditCard) {
        isAddCreditCard = false;
        return true;
      }
      $('#is_error_add_card').remove();
      $('#card-token').remove();
      $('#error_add_card_form').remove();
      $('#place_order').attr('disabled', true);

      vgsForm.submit(
        "/api/v1/cards/vgs",
        {},
        (status, response) => {
          if (status === 200) {
            $('<input>').attr({
              type: 'hidden',
              id: vgs_config.waave_form_id+'-card-token',
              name: vgs_config.waave_form_id+'-card-token',
              value: response.card_token,
            }).appendTo('form[name="checkout"]');
          } else {
            $('<input>').attr({
              type: 'hidden',
              id: 'is_error_add_card',
              name: 'is_error_add_card',
              value: true,
            }).appendTo('form[name="checkout"]');
          }
          isAddCreditCard = true;
          $('form[name="checkout"]').submit();
          $('#place_order').attr('disabled', false);
        },
        (errors) => {
          let errorsMess = [];
          Object.keys(errors).forEach(function (key, index) {
            let errorEle = null;
            let errorFieldName = null;
            switch (key) {
              case "cvv":
                errorFieldName = "The CVC ";
                break;
              case "card_exp":
                errorFieldName = "The card expiration ";
                break;
              case "card_number":
                errorFieldName = "The card number ";
                break;
              default:
                errorField = key.replace('_', ' ');
                errorFieldName = errorField[0].toUpperCase() + errorField.slice(1) + ' ';   //capitalize first letter
            }
            errorEle = errors[key].errorMessages;
            errorEle.map(function (element) {
              errorsMess.push(errorFieldName + element);
            });
          });
          $('<input>').attr({
            type: 'hidden',
            id: 'is_error_add_card',
            name: 'is_error_add_card',
            value: true,
          }).appendTo('form[name="checkout"]');
          $('<input>').attr({
            type: 'hidden',
            id: 'error_add_card_form',
            name: 'error_add_card_form',
            value: errorsMess.join('|'),
          }).appendTo('form[name="checkout"]');
          isAddCreditCard = true;
          $('form[name="checkout"]').submit();
          $('#place_order').attr('disabled', false);
        }
      );
      if (isDenied) {
        isNeedAgeCheck = true;
      }
      $('form.checkout').addClass('waave-processing');
      return false;
    });

    $('.age-check-dob-btn-yes').on('click', function() {
      if (uuid && !isRegenerateAgeCheck) {
        AgeCheckerAPI.show(uuid);
        $('.age-check-dob-overlay').hide();
      } else {
        let first_name =  $('#billing_first_name').val();
        let last_name = $('#billing_last_name').val();
        let country = $('#billing_country').val();
        let address1 = $('#billing_address_1').val();
        let address2 = $('#billing_address_2').val();
        let city = $('#billing_city').val();
        let state = $('#billing_state').val();
        let postcode = $('#billing_postcode').val();
        if ($('#ship-to-different-address-checkbox').is(':checked')) {
          first_name = $('#shipping_first_name').val();
          last_name = $('#shipping_last_name').val();
          country = $('#shipping_country').val();
          address1 = $('#shipping_address_1').val();
          address2 = $('#shipping_address_2').val();
          city = $('#shipping_city').val();
          state = $('#shipping_state').val();
          postcode = $('#shipping_postcode').val();
        }
        let data = {
          'dob_day'           : $('select#age_check_dob_day').val(),
          'dob_month'         : $('select#age_check_dob_month').val(),
          'dob_year'          : $('select#age_check_dob_year').val(), 
          'age_check_id'      : age_check_id,
          'shipping'          : {
            'shipping_first_name': first_name,
            'shipping_last_name': last_name,
            'shipping_country': country,
            'shipping_address_1': address1,
            'shipping_address_2': address2,
            'shipping_city': city,
            'shipping_state': state,
            'shipping_postcode': postcode
          }
        };
        $('.age-check-dob-overlay').hide();
        $.ajax({
          type: "POST",
          url: vgs_config.waave_url+'/compliance/age-check-validate',
          data:  data,
          dataType: "json",
          success: function (data) {
            if (data.success) {
              $('.woocommerce-error').remove();
              if (data.uuid) {
                uuid = data.uuid;
                if (data.status && data.status == 'accepted') {
                  isNeedAgeCheck = false;
                  $('<input>').attr({
                    type: 'hidden',
                    id: 'uuid',
                    name: 'uuid',
                    value: uuid,
                  }).appendTo('form[name="checkout"]');
                  $('<input>').attr({
                    type: 'hidden',
                    id: 'age_check_id',
                    name: 'age_check_id',
                    value: age_check_id,
                  }).appendTo('form[name="checkout"]');
                  $('form[name="checkout"]').submit();
                } else {
                  if (isRegenerateAgeCheck) AgeCheckerAPI.show(uuid);
                  else ageCheckPopup(vgs_config.age_checker, data.uuid);
                }
              } else {
                if (data.message) {
                  $('.woocommerce-error').children('li').remove();
                  $(".woocommerce-error").append('<li>'+data.message+'</li>');
                  $(".woocommerce-error").show();
                }
              }
            }
          },
          error: function (xhr, status, error) {
            let message = 'Something errors. Please reload and try again.';
            if ((typeof xhr.responseJSON.message !== 'undefined')) message = xhr.responseJSON.message;
            $('.woocommerce-error').children('li').remove();
            $(".woocommerce-error").append('<li>' + message + '</li>');
            $(".woocommerce-error").show();
          }
        });
      }
    })
    $('.age-check-dob-btn-no').on('click', function() {
      $('.age-check-dob-overlay').hide();
    })
  });

  function ageCheckPopup(key, uuid) {
    (function (w, d) {
      var config = {
          mode: "manual",
          key: key,
          show_close: true,
          logo_url: vgs_config.waave_logo,
          onhide: function () {
            uuid = null;
            $('body').css('overflow', 'unset');
          },
          onready: function () {
            AgeCheckerAPI.show(uuid);
          },
          onshow: function () {
            var agecheckerFooterStr = ''
             + '<div style="display:inline-block;margin-right: 20px;">'
             +     'Need help? Email us at <a href="mailto:support@getwaave.com" target="_blank"><span>support@getwaave.com</span></a>'
             + '</div>'
             + '<div style="display:inline-block;">'
             +     '<a href="http://static.getwaave.co/info/tos.html" target="_blank" rel="noopener">Terms of Service & Privacy Policy</a>'
             + '</div>';
            $('#agechecker #ac-footer').html(agecheckerFooterStr);
          },
          onstatuschanged: function (verification) {
            let statusDenied = ['pending', 'denied'];
            if (statusDenied.includes(verification.status)) {
              isDenied = true;
              isRegenerateAgeCheck = true;
            }
            isNeedAgeCheck = false;
            $('#agechecker-modal').remove();
            $('input').attr("readonly", false).css({"opacity": "unset", "pointer-events": "unset"});
            $('body').css('overflow', 'unset');
            $('<input>').attr({
              type: 'hidden',
              id: 'uuid',
              name: 'uuid',
              value: uuid,
            }).appendTo('form[name="checkout"]');
            $('<input>').attr({
              type: 'hidden',
              id: 'age_check_id',
              name: 'age_check_id',
              value: age_check_id,
            }).appendTo('form[name="checkout"]');
            $('form[name="checkout"]').submit();
          }
      };
      w.AgeCheckerConfig = config;
      if (config.path && (w.location.pathname + w.location.search).indexOf(config.path)) return;
      var h = d.getElementsByTagName("head")[0];
      var a = d.createElement("script");
      a.src = "https://cdn.agechecker.net/static/popup/v1/popup.js";
      a.crossOrigin = "anonymous";
      a.onerror = function (a) {
          w.location.href = "https://agechecker.net/loaderror";
      }
      h.insertBefore(a, h.firstChild);
    })(window, document);
  }
});