jQuery(function ($) {
  $('#waave-cancel-button, #waave-close-button').on('click', function () {
    $('#waave-setup-popup').hide();
  });

  $('#waave-setup-form').on('submit', function(e) {
    e.preventDefault();

    const $spinner = $('#waave-loading-spinner');
    $spinner.css('visibility', 'visible');

    const $submitBtn = $('#waave-submit-button');
    $submitBtn.prop('disabled', true);

    var data = {
      action: 'waave_complete_save_settings_popup',
      email: $('#waave-email').val(),
      password: $('#waave-password').val(),
      testmode: $('#waave-testmode').is(':checked') ? '1' : '0',
      nonce: $('#waave-nonce').val()
    };

    $.post(ajaxurl, data, function(response) {
      $('#waave-form-message')
        .addClass('notice ' + (response.success ? 'notice-success' : 'notice-error'))
        .html('<p>' + response.data.message + '</p>')
        .show();

      if (response.success) {
        $('#waave-close-button').show();
      }
    }).fail(function(xhr) {
      $('#waave-form-message')
        .addClass('notice notice-error')
        .html('<p>An error occurred.</p>')
        .show();
    }).always(function() {
      $spinner.css('visibility', 'hidden');
      $submitBtn.prop('disabled', false);
    });
  });

  $('#waave-setup-form .show-password-input').on('click', function() {
    const input = $('#waave-password');
    const isPassword = input.attr('type') === 'password';
    input.attr('type', isPassword ? 'text' : 'password');

    $(this).toggleClass('display-password');
  });
});
