jQuery(function ($) {
  var isNeedAgeCheck = true;
  var ageCheckMode = vgs_config.age_checker_mode === "1" ? true : false;
  var isAddCreditCard = false;
  var isDenied = false;
  var isRegenerateAgeCheck = false;
  var uuid = null;
  var age_check_id = null;
  var vgsForm = null;
  var isCardNumberKeyup = false;
  var isExpirationKeyup = false;
  var isCVCKeyup = false;
  var canBeEnrolled = false;
  var isFlexiPay = false;
  var isDsFlag = false;

  function ageCheckPopup(key, uuid) {
    (function (w, d) {
      var config = {
        mode: "manual",
        key: key,
        show_close: true,
        logo_url: vgs_config.incognito ? "" : vgs_config.waave_logo,
        onhide: function () {
          uuid = null;
          $("body").css("overflow", "unset");
        },
        onready: function () {
          AgeCheckerAPI.show(uuid);
        },
        onshow: function () {
          if (vgs_config.incognito) {
            return;
          }

          var agecheckerFooterStr =
            "" +
            '<div style="display:inline-block;margin-right: 20px;">' +
            'Need help? Email us at <a href="mailto:support@getwaave.com" target="_blank"><span>support@getwaave.com</span></a>' +
            "</div>" +
            '<div style="display:inline-block;">' +
            '<a href="http://static.getwaave.co/info/tos.html" target="_blank" rel="noopener">Terms of Service & Privacy Policy</a>' +
            "</div>";
          $("#agechecker #ac-footer").html(agecheckerFooterStr);
        },
        onstatuschanged: function (verification) {
          let statusDenied = ["pending", "denied"];
          if (statusDenied.includes(verification.status)) {
            isDenied = true;
            isRegenerateAgeCheck = true;
          }
          isNeedAgeCheck = false;
          $("#agechecker-modal").remove();
          $("input")
            .attr("readonly", false)
            .css({ opacity: "unset", "pointer-events": "unset" });
          $("body").css("overflow", "unset");
          $("<input>")
            .attr({
              type: "hidden",
              id: "uuid",
              name: "uuid",
              value: uuid,
            })
            .appendTo("form.checkout");
          $("<input>")
            .attr({
              type: "hidden",
              id: "age_check_id",
              name: "age_check_id",
              value: age_check_id,
            })
            .appendTo("form.checkout");
          $("form.checkout").submit();
        },
      };
      w.AgeCheckerConfig = config;
      if (
        config.path &&
        (w.location.pathname + w.location.search).indexOf(config.path)
      )
        return;
      var h = d.getElementsByTagName("head")[0];
      var a = d.createElement("script");
      a.src = "https://cdn.agechecker.net/static/popup/v1/popup.js";
      a.crossOrigin = "anonymous";
      a.onerror = function (a) {
        w.location.href = "https://agechecker.net/loaderror";
      };
      h.insertBefore(a, h.firstChild);
    })(window, document);
  }

  function collectDeviceInformation(response) {
    if (
      !response.flexipay_access_token ||
      !response.flexipay_device_data_collection_url
    ) {
      return;
    }

    isFlexiPay = true;

    window.addEventListener(
      "message",
      function (event) {
        if (event.origin !== "https://centinelapi.cardinalcommerce.com") {
          return;
        }

        const data = JSON.parse(event.data);

        if (true !== data.Status) {
          return;
        }

        canBeEnrolled = true;

        const browserInfo = {
          http_accept_content:
            navigator.acceptLanguages?.join(",") || navigator.language,
          http_browser_language: navigator.language || navigator.userLanguage,
          http_browser_java_enabled: navigator.javaEnabled(),
          http_browser_javascript_enabled: true,
          http_browser_color_depth: screen.colorDepth,
          http_browser_screen_height: screen.height,
          http_browser_screen_width: screen.width,
          http_browser_time_difference: new Date().getTimezoneOffset(),
          user_agent_browser_value: navigator.userAgent,
        };

        $("<input>")
          .attr({
            type: "hidden",
            id: "enroll_data",
            name: "enroll_data",
            value: JSON.stringify(browserInfo),
          })
          .appendTo("form.checkout");

        $("<input>")
          .attr({
            type: "hidden",
            id: "flexipay_access_token",
            name: "flexipay_access_token",
            value: response.flexipay_access_token,
          })
          .appendTo("form.checkout");

        $("form.checkout").submit();
      },
      false
    );

    $("#collection-form-input").val(response.flexipay_access_token);
    $("#collection-form").prop(
      "action",
      response.flexipay_device_data_collection_url
    );
    $("#collection-form").submit();
  }

  function continuePayment(data) {
    $("form.checkout").block({
      message: null,
      overlayCSS: {
        background: "#fff",
        opacity: 0.6,
      },
    });

    $.ajax({
      type: "POST",
      url: "/?wc-ajax=waave_complete_flexipay_continue_payment",
      data: {
        order_id: data.order_id,
        parseDsThirdParties: data.parseDsThirdParties
      },
      dataType: "json",
      success: function (result) {
        $("form.checkout").unblock();

        if ("success" !== result.result) {
          if (result.message) {
            _showCheckoutError(result.message);
          }
          return;
        }

        if (
          -1 === result.redirect.indexOf("https://") ||
          -1 === result.redirect.indexOf("http://")
        ) {
          window.location = result.redirect;
        } else {
          window.location = decodeURI(result.redirect);
        }
      },
    });
  }

  function _showCheckoutError(message) {
    $(".woocommerce-error").remove();
    $("form.checkout").prepend(
      '<div class="woocommerce-error">' + message + "</div>"
    );
  }

  $(document.body).on("updated_checkout", function () {
    isNeedAgeCheck = !!$("#is_need_age_check").val();
    age_check_id = $("#age_check_id").val();

    if (vgsForm) {
      vgsForm.unmount();
    }

    vgsForm = window.VGSCollect.create(
      window.atob(vgs_config.vault_id),
      vgs_config.env,
      () => {}
    );

    if (isDsFlag) {
      vgsForm.field("#venue_id", {
        type: "text",
        name: "venue_id",
        defaultValue: vgs_config.venue_id,
        validations: ["required"],
      });
    }

    const css = {
      boxSizing: "border-box",
      fontFamily: '-apple-system, BlinkMacSystemFont, "Segoe UI"',
    };

    vgsCardNumber = vgsForm.field("#cc-number", {
      type: "card-number",
      name: "card_number",
      successColor: "#4F8A10",
      errorColor: "#D8000C",
      placeholder: "Card number",
      showCardIcon: true,
      validations: ["required", "validCardNumber"],
      css: css,
    });

    vgsCardNumber.on("focus", () => {
      isAddCreditCard = false;
      isCardNumberKeyup = true;
      $("#is_error_add_card").remove();
      $("#error_add_card_form").remove();
    });

    vgsCvv = vgsForm.field("#cc-cvc", {
      type: "card-security-code",
      name: "cvv",
      successColor: "#4F8A10",
      errorColor: "#D8000C",
      placeholder: "CVC",
      validations: ["required", "validCardSecurityCode"],
      css: css,
    });

    vgsCvv.on("focus", () => {
      isAddCreditCard = false;
      isCVCKeyup = true;
      $("#is_error_add_card").remove();
      $("#error_add_card_form").remove();
    });

    vgscardExp = vgsForm.field("#cc-expiration-date", {
      type: "card-expiration-date",
      name: "card_exp",
      successColor: "#4F8A10",
      errorColor: "#D8000C",
      placeholder: "MM / YY",
      validations: ["required", "validCardExpirationDate"],
      css: css,
    });

    vgscardExp.on("focus", () => {
      isAddCreditCard = false;
      isExpirationKeyup = true;
      $("#is_error_add_card").remove();
      $("#error_add_card_form").remove();
    });
  });

  $(document).ready(function () {
    $("#billing_email").change(function () {
      $(document.body).trigger("update_checkout", {
        update_shipping_method: false,
      });
    });

    $("form.checkout").on("checkout_place_order_waave_checkout", function (e) {
      $("div.woocommerce-notices-wrapper")
        .last()
        .html(
          "<ul class='woocommerce-error' role='alert' style='display:none'></ul>"
        );

      if (!isNeedAgeCheck || !ageCheckMode) {
        if (isDenied) {
          isNeedAgeCheck = true;
          isDenied = false;
        }
        return true;
      }

      $(".age-check-dob-overlay").show();

      return false;
    });

    $("form.checkout").on(
      "checkout_place_order_waave_guest_credit_card",
      function (e) {
        if (isFlexiPay) {
          isFlexiPay = false;
          return true;
        }

        $("div.woocommerce-notices-wrapper")
          .last()
          .html(
            "<ul class='woocommerce-error' role='alert' style='display:none'></ul>"
          );

        if (isNeedAgeCheck && ageCheckMode) {
          if (isDenied) {
            isDenied = false;
          } else {
            if (isCardNumberKeyup && isCVCKeyup && isExpirationKeyup) {
              $(".age-check-dob-overlay").show();
            } else {
              $(".woocommerce-error").children("li").remove();
              if (!isCardNumberKeyup)
                $(".woocommerce-error").append(
                  "<li>The card number is required</li>"
                );
              if (!isExpirationKeyup)
                $(".woocommerce-error").append(
                  "<li>The card expiration is required</li>"
                );
              if (!isCVCKeyup)
                $(".woocommerce-error").append("<li>The CVC is required</li>");
              $(".woocommerce-error").show();
            }

            return false;
          }
        }

        if (isAddCreditCard) {
          isAddCreditCard = false;

          return true;
        }

        $("#is_error_add_card").remove();
        $("#card-token").remove();
        $("#error_add_card_form").remove();

        $("form.checkout").block({
          message: null,
          overlayCSS: {
            background: "#fff",
            opacity: 0.6,
          },
        });

        vgsForm.submit(
          "/api/v1/cards/vgs",
          {},
          (status, response) => {
            if (status === 200) {
              $("<input>")
                .attr({
                  type: "hidden",
                  id: vgs_config.waave_form_id + "-card-token",
                  name: vgs_config.waave_form_id + "-card-token",
                  value: response.card_token,
                })
                .appendTo("form.checkout");

              // Card #764, 3ds
              collectDeviceInformation(response);
            } else {
              $("<input>")
                .attr({
                  type: "hidden",
                  id: "is_error_add_card",
                  name: "is_error_add_card",
                  value: true,
                })
                .appendTo("form.checkout");
            }

            isAddCreditCard = true;

            if (isFlexiPay) {
              return;
            }

            $("form.checkout").submit();
          },
          (errors) => {
            let errorsMess = [];
            Object.keys(errors).forEach(function (key, index) {
              let errorEle = null;
              let errorFieldName = null;
              switch (key) {
                case "cvv":
                  errorFieldName = "The CVC ";
                  break;
                case "card_exp":
                  errorFieldName = "The card expiration ";
                  break;
                case "card_number":
                  errorFieldName = "The card number ";
                  break;
                default:
                  errorField = key.replace("_", " ");
                  errorFieldName =
                    errorField[0].toUpperCase() + errorField.slice(1) + " "; //capitalize first letter
              }
              errorEle = errors[key].errorMessages;
              errorEle.map(function (element) {
                errorsMess.push(errorFieldName + element);
              });
            });
            $("<input>")
              .attr({
                type: "hidden",
                id: "is_error_add_card",
                name: "is_error_add_card",
                value: true,
              })
              .appendTo("form.checkout");
            $("<input>")
              .attr({
                type: "hidden",
                id: "error_add_card_form",
                name: "error_add_card_form",
                value: errorsMess.join("|"),
              })
              .appendTo("form.checkout");

            isAddCreditCard = true;
            $("form.checkout").submit();
          }
        );

        if (isDenied) {
          isNeedAgeCheck = true;
        }

        return false;
      }
    );

    $("form.checkout").on("checkout_place_order_success", function (_, result) {
      if (!canBeEnrolled) {
        return true;
      }

      if (!result?.access_token || !result?.stepup_url) {
        return true;
      }

      // show otp screen if result have token and url
      window.addEventListener(
        "message",
        function (event) {
          if (event.origin !== "https://api.flexipay.com.co") {
            return;
          }

          $("#step-up-iframe-overlay").css("display", "none");

          const data = event.data;
          if (!data || !data.enroll) {
            return;
          }

          const enroll = data.enroll;

          if ("AUTHENTICATION_SUCCESSFUL" !== enroll?.status) {
            return;
          }

          const consumerAuthenticationInformation = enroll?.consumerAuthenticationInformation;

          let parseDsThirdParties = {};

          if (consumerAuthenticationInformation?.eci) {
            parseDsThirdParties = {
              threeDSService: {
                status: consumerAuthenticationInformation.paresStatus,
                eci: consumerAuthenticationInformation?.eci,
                cavv: consumerAuthenticationInformation?.cavv,
                xid: consumerAuthenticationInformation?.directoryServerTransactionId,
                version: consumerAuthenticationInformation?.specificationVersion,
              },
            };
          } else if (consumerAuthenticationInformation?.ucafAuthenticationData) {
            parseDsThirdParties = {
              threeDSMCService: {
                directoryServerTransactionId: consumerAuthenticationInformation?.directoryServerTransactionId,
                ucafCollectionIndicator: consumerAuthenticationInformation?.ucafCollectionIndicator,
                ucafAuthenticationData: consumerAuthenticationInformation?.ucafAuthenticationData,
                specificationVersion: consumerAuthenticationInformation?.specificationVersion,
              },
            };
          }

          result['parseDsThirdParties'] = parseDsThirdParties;

          continuePayment(result);
        },
        false
      );

      // Update form with token and url then submit enroll
      $("#step-up-form-jwt").val(result.access_token);

      const md = {
        MD: {
          idCuenta: result.flexipay_md,
        },
      };
      $("#step-up-form-md").val(JSON.stringify(md));

      $("#step-up-form").prop("action", result.stepup_url);
      $("#step-up-form").submit();

      $("#step-up-iframe-overlay").css("display", "flex");

      setTimeout(function () {
        $(".woocommerce-error").remove();
      }, 1000);

      return false;
    });

    $(".age-check-dob-btn-yes").on("click", function () {
      if (uuid && !isRegenerateAgeCheck) {
        AgeCheckerAPI.show(uuid);
        $(".age-check-dob-overlay").hide();
      } else {
        let first_name = $("#billing_first_name").val();
        let last_name = $("#billing_last_name").val();
        let country = $("#billing_country").val();
        let address1 = $("#billing_address_1").val();
        let address2 = $("#billing_address_2").val();
        let city = $("#billing_city").val();
        let state = $("#billing_state").val();
        let postcode = $("#billing_postcode").val();
        if ($("#ship-to-different-address-checkbox").is(":checked")) {
          first_name = $("#shipping_first_name").val();
          last_name = $("#shipping_last_name").val();
          country = $("#shipping_country").val();
          address1 = $("#shipping_address_1").val();
          address2 = $("#shipping_address_2").val();
          city = $("#shipping_city").val();
          state = $("#shipping_state").val();
          postcode = $("#shipping_postcode").val();
        }
        let data = {
          dob_day: $("select#age_check_dob_day").val(),
          dob_month: $("select#age_check_dob_month").val(),
          dob_year: $("select#age_check_dob_year").val(),
          age_check_id: age_check_id,
          shipping: {
            shipping_first_name: first_name,
            shipping_last_name: last_name,
            shipping_country: country,
            shipping_address_1: address1,
            shipping_address_2: address2,
            shipping_city: city,
            shipping_state: state,
            shipping_postcode: postcode,
          },
        };
        $(".age-check-dob-overlay").hide();
        $.ajax({
          type: "POST",
          url: vgs_config.waave_url + "/compliance/age-check-validate",
          data: data,
          dataType: "json",
          success: function (data) {
            if (data.success) {
              $(".woocommerce-error").remove();
              if (data.uuid) {
                uuid = data.uuid;
                if (data.status && data.status == "accepted") {
                  isNeedAgeCheck = false;
                  $("<input>")
                    .attr({
                      type: "hidden",
                      id: "uuid",
                      name: "uuid",
                      value: uuid,
                    })
                    .appendTo("form.checkout");
                  $("<input>")
                    .attr({
                      type: "hidden",
                      id: "age_check_id",
                      name: "age_check_id",
                      value: age_check_id,
                    })
                    .appendTo("form.checkout");
                  $("form.checkout").submit();
                } else {
                  if (isRegenerateAgeCheck) AgeCheckerAPI.show(uuid);
                  else ageCheckPopup(vgs_config.age_checker, data.uuid);
                }
              } else {
                if (data.message) {
                  $(".woocommerce-error").children("li").remove();
                  $(".woocommerce-error").append(
                    "<li>" + data.message + "</li>"
                  );
                  $(".woocommerce-error").show();
                }
              }
            }
          },
          error: function (xhr, status, error) {
            let message = "Something errors. Please reload and try again.";
            if (typeof xhr.responseJSON.message !== "undefined")
              message = xhr.responseJSON.message;
            $(".woocommerce-error").children("li").remove();
            $(".woocommerce-error").append("<li>" + message + "</li>");
            $(".woocommerce-error").show();
          },
        });
      }
    });

    $(".age-check-dob-btn-no").on("click", function () {
      $(".age-check-dob-overlay").hide();
    });
  });
});
